/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.builder;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.JOptionPane;
import replicatorg.drivers.SDCardCapture;
import replicatorg.machine.Machine;
import replicatorg.machine.builder.MachineBuilder;

public class UsingRemoteFile
implements MachineBuilder {
    SDCardCapture sdcc;
    boolean finished = false;
    static Map<SDCardCapture.ResponseCode, String> sdErrorMap = new EnumMap<SDCardCapture.ResponseCode, String>(SDCardCapture.ResponseCode.class);

    public UsingRemoteFile(SDCardCapture sdcc, String remoteName) {
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_NO_CARD, "No SD card was detected.  Please make sure you have a working, formatted\nSD card in the motherboard's SD slot and try again.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_INIT, "ReplicatorG was unable to initialize the SD card.  Please make sure that\nthe SD card works properly.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_PARTITION, "ReplicatorG was unable to read the SD card's partition table.  Please check\nthat the card is partitioned properly.\nIf you believe your SD card is OK, try resetting your device and restarting\nReplicatorG.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_FS, "ReplicatorG was unable to open the filesystem on the SD card.  Please make sure\nthat the SD card has a single partition formatted with a FAT16 filesystem.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_ROOT_DIR, "ReplicatorG was unable to read the root directory on the SD card.  Please\ncheck to see if the SD card was formatted properly.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_LOCKED, "The SD card cannot be written to because it is locked.  Remove the card,\nswitch the lock off, and try again.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_NO_FILE, "ReplicatorG could not find the build file on the SD card.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_GENERIC, "Unknown SD card error.");
        this.sdcc = sdcc;
        if (!this.processSDResponse(sdcc.playback(remoteName))) {
            this.finished = true;
        }
    }

    @Override
    public boolean finished() {
        return this.sdcc.isFinished();
    }

    @Override
    public void runNext() {
    }

    @Override
    public int getLinesProcessed() {
        return 0;
    }

    @Override
    public int getLinesTotal() {
        return 0;
    }

    public boolean processSDResponse(SDCardCapture.ResponseCode code) {
        if (code == SDCardCapture.ResponseCode.SUCCESS) {
            return true;
        }
        String message = sdErrorMap.get((Object)code);
        JOptionPane.showMessageDialog(null, message, "SD card error", 0);
        return false;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public Machine.JobTarget getTarget() {
        return Machine.JobTarget.MACHINE;
    }
}

